#include <iostream>
#include <vector>
#include <algorithm>
#include <list>
#include <set>
#include <bitset>
#include <intrin.h>
#pragma intrinsic(_BitScanForward)

using namespace std;

typedef unsigned long long int ull;

const int M = 100000;

int cpt(int x) {
    x--;
    x |= x >> 1;
    x |= x >> 2;
    x |= x >> 4;
    x |= x >> 8;
    x |= x >> 16;
    x++;

    return x;
}

int bnum(int x) {
    int p = cpt(x);
    
    unsigned long m = p;
    unsigned long i;
    unsigned char tmp;
    
    tmp = _BitScanForward(&i, m);

    return i + !(x & (x - 1));
}

int flop(int n) {
    if (!n) return 0;
    int l = ~((1 << bnum(n)) -1 );
    int x = ((~n) ^ (l));

    return x;
}
int a[M];
int dp[M] = {};

void solve() {
	int n;
	cin >> n;
    n++;

    for (int i = 0; i < n; i++)dp[i] = -1;

    ull s = 0;
    for (int i = n - 1; i >= 0; i--) {
        int x = flop(i);
        
        if(dp[i]==-1) {
            dp[x] = i;
            dp[i] = x;
            
            ull xr = i ^ x;
            s += (xr<<1);
        }
        //cout << i << ' ' << dp[i] << endl;
    }
    
    for (int i = 0; i < n; i++) cin >> a[i];

    cout << s << endl;

    for (int i = 0; i < n; i++) {
        cout << dp[a[i]] << ' ';
    }cout<<endl;
}

int main() {

    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;
    while (t--)
        solve();
}